﻿using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class ProviderServicesController : ODataController
    {
        [ODataRoute("ProviderServices({Name})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string Name)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Service record
                var ppmsProviderService =
                    context.ppms_providerserviceSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsProviderService != null)
                {
                    //Map Provider Service
                    var ppmsProviderServiceList = new List<ppms_providerservice> {ppmsProviderService};
                    var providerService =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServiceList, queryType, context);
                    return Request.CreateResponse(providerService);
                }
            }
            var message = string.Format("Provider Service with Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderServices({Name})/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] string Name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Service record
                var ppmsProviderService =
                    context.ppms_providerserviceSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsProviderService != null)
                {
                    //Retrieve and Return the related Provider
                    var ppmsProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderService.ppms_ProviderId.Id);
                    var ppmsProvidersList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None");
                    return Request.CreateResponse(provider);
                }
            }
            var message = string.Format("Provider with Provider Service Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderServices({Name})/Specialty")]
        public async Task<HttpResponseMessage> GetSpecialty([FromODataUri] string Name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Service record
                var ppmsProviderService =
                    context.ppms_providerserviceSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsProviderService != null)
                {
                    //Retrieve and Return the related Specialty
                    var ppmsSpecialty =
                        context.ppms_taxonomySet.FirstOrDefault(i => i.Id == ppmsProviderService.ppms_specialty.Id);
                    var ppmsSpecialtiesList = new List<ppms_taxonomy> { ppmsSpecialty };
                    var specialty =
                        await SpecialtyMap.MapSpecialties(ppmsSpecialtiesList, "None", context);
                    return Request.CreateResponse(specialty);
                }
            }
            var message = string.Format("Specialty with Provider Service Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderServices({Name})/ServiceAvailabilities")]
        public async Task<HttpResponseMessage> GetServiceAvailabilities([FromODataUri] string Name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Service record
                var ppmsProviderService =
                    context.ppms_providerserviceSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsProviderService != null)
                {
                    //Retrieve and Return the related Service Availabilities
                    var ppmsServiceAvailabilities =
                        context.ppms_serviceavailabilitySet.Where(i => i.ppms_ProviderServiceId.Id == ppmsProviderService.Id);
                    var ppmsServiceAvailabilitiesList = ppmsServiceAvailabilities.ToList();
                    var serviceAvailabilities =
                        await ServiceAvailabilityMap.MapServiceAvailabilities(ppmsServiceAvailabilitiesList, "None",
                            context);
                    return Request.CreateResponse(serviceAvailabilities);

                }
            }
            var message = string.Format("Service Availabilities with Provider Service Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderServices({Name})/AgreementProviders")]
        public async Task<HttpResponseMessage> GetAgreementProviders([FromODataUri] string Name)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Service record
                var ppmsProviderService =
                    context.ppms_providerserviceSet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsProviderService != null)
                {
                    //Retrieve and Return the related Agreement Providers
                    var ppmsAgreementProviders =
                        context.ppms_agreementproviderSet.Where(
                            i => i.ppms_ProviderAgreement.Id == ppmsProviderService.Id);
                    var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                    var agreementProviders =
                        await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None",
                            context);
                    return Request.CreateResponse(agreementProviders);
                }
            }
            var message = string.Format("Agreement Providers with Provider Service Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderServices")]
        public async Task<HttpResponseMessage> Get()
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_ProviderId != null && i.ppms_specialty != null).Take(50);
                var ppmsProviderServicesList = ppmsProviderServices.ToList();
                if (ppmsProviderServicesList.Any())
                {                                      
                    var providerServices = await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
                var message = "Provider Services Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }
    }
}